SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO

CREATE TABLE [MSSR].[MSSR_Procedure_X_Type_of_Imaging](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[procedure_modifiers] [numeric](28, 6) NULL,
	[childsub1] [numeric](28, 6) NULL,
	[type_of_imaging] [numeric](28, 6) NULL,
	[typeofimagingx] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Common_Procedures_X_Procedure_Modifiers](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[radnuc_med_common_procedure] [numeric](28, 6) NULL,
	[childsub1] [numeric](28, 6) NULL,
	[procedure_modifiers] [numeric](28, 6) NULL,
	[proceduremodifiersx] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Complication_Types](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[complication] [varchar](8000) NULL,
	[contrast_medium_reaction] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Contractsharing_Agreements](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[agreement_name] [varchar](8000) NULL,
	[type_of_agreement] [varchar](8000) NULL,
	[inactivation_date] [datetime2](7) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Contrast_Media](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[radnuc_med_procedures] [numeric](28, 6) NULL,
	[childsub1] [numeric](28, 6) NULL,
	[contrast_media] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Diagnostic_Codes](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[number] [numeric](28, 6) NULL,
	[diagnostic_code] [varchar](8000) NULL,
	[description] [varchar](8000) NULL,
	[print_on_abnormal_report] [varchar](8000) NULL,
	[generate_abnormal_alert] [varchar](8000) NULL,
	[inactive] [varchar](8000) NULL,
	[expressionid] [numeric](28, 6) NULL,
	[expression] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Examanation_Status](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[status] [varchar](8000) NULL,
	[technologist_required] [varchar](8000) NULL,
	[report_entered_required] [varchar](8000) NULL,
	[verified_report_required] [varchar](8000) NULL,
	[procedure_modifiers_required] [varchar](8000) NULL,
	[cpt_modifiers_required] [varchar](8000) NULL,
	[impression_required] [varchar](8000) NULL,
	[resident_or_staff_required] [varchar](8000) NULL,
	[detailed_procedure_required] [varchar](8000) NULL,
	[film_entry_required] [varchar](8000) NULL,
	[diagnostic_code_required] [varchar](8000) NULL,
	[cameraequiprm_required] [varchar](8000) NULL,
	[ask_for_technologist] [varchar](8000) NULL,
	[ask_for_user_code] [varchar](8000) NULL,
	[ask_procedure_modifiers] [varchar](8000) NULL,
	[ask_cpt_modifiers] [varchar](8000) NULL,
	[ask_for_interpreting_phys] [varchar](8000) NULL,
	[ask_for_procedure] [varchar](8000) NULL,
	[ask_for_film_data] [varchar](8000) NULL,
	[ask_for_diagnostic_code] [varchar](8000) NULL,
	[ask_for_cameraequiprm] [varchar](8000) NULL,
	[ask_medications__dosages] [varchar](8000) NULL,
	[ask_med_adm_dttimeperson] [varchar](8000) NULL,
	[clinic_report] [varchar](8000) NULL,
	[cameraequiprm_report] [varchar](8000) NULL,
	[physician_report] [varchar](8000) NULL,
	[resident_report] [varchar](8000) NULL,
	[staff_report] [varchar](8000) NULL,
	[delinquent_status_report] [varchar](8000) NULL,
	[ptf_bedsection_report] [varchar](8000) NULL,
	[service_report] [varchar](8000) NULL,
	[sharingcontract_report] [varchar](8000) NULL,
	[ward_report] [varchar](8000) NULL,
	[film_usage_report] [varchar](8000) NULL,
	[technologist_report] [varchar](8000) NULL,
	[amis_report] [varchar](8000) NULL,
	[detailed_procedure_report] [varchar](8000) NULL,
	[radiopharmsdosages_required] [varchar](8000) NULL,
	[activity_drawn_required] [varchar](8000) NULL,
	[drawn_dttimeperson_required] [varchar](8000) NULL,
	[adm_dttimeperson_required] [varchar](8000) NULL,
	[routesite_required] [varchar](8000) NULL,
	[lot_no_required] [varchar](8000) NULL,
	[volumeform_required] [varchar](8000) NULL,
	[ask_radiopharms_and_dosages] [varchar](8000) NULL,
	[print_dosage_ticket] [varchar](8000) NULL,
	[ask_activity_drawn] [varchar](8000) NULL,
	[ask_drawn_dttimeperson] [varchar](8000) NULL,
	[ask_adm_dttimeperson] [varchar](8000) NULL,
	[ask_routesite_of_adm] [varchar](8000) NULL,
	[ask_lot_no] [varchar](8000) NULL,
	[ask_volumeform] [varchar](8000) NULL,
	[generate_exam_alert] [varchar](8000) NULL,
	[default_next_status] [numeric](28, 6) NULL,
	[defaultnextstatusx] [varchar](8000) NULL,
	[order3] [numeric](28, 6) NULL,
	[user_key_needed] [numeric](28, 6) NULL,
	[userkeyneededx] [varchar](8000) NULL,
	[appear_on_status_tracking] [varchar](8000) NULL,
	[allow_cancelling] [varchar](8000) NULL,
	[type_of_imaging] [numeric](28, 6) NULL,
	[typeofimagingx] [varchar](8000) NULL,
	[generate_examined_hl7_message] [varchar](8000) NULL,
	[vistarad_category] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Examine_X_Medication](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[sub_examinations] [varchar](8000) NULL,
	[childsub3] [numeric](28, 6) NULL,
	[med_administered] [numeric](28, 6) NULL,
	[medadministeredx] [varchar](8000) NULL,
	[med_dose] [varchar](8000) NULL,
	[datetime_med_administered] [datetime2](7) NULL,
	[person_who_administered_med] [numeric](28, 6) NULL,
	[personwhoadministeredmedx] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Hold_Description](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[radnuc_med_orders] [numeric](28, 6) NULL,
	[childsub1] [numeric](28, 6) NULL,
	[hold_description] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Imaging_Locations](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[location] [numeric](28, 6) NULL,
	[locationx] [varchar](8000) NULL,
	[how_many_flash_cards_per_visit] [numeric](28, 6) NULL,
	[flash_card_printer_name] [numeric](28, 6) NULL,
	[flashcardprinternamex] [varchar](8000) NULL,
	[how_many_jacket_lbls_per_visit] [numeric](28, 6) NULL,
	[jacket_label_printer_name] [numeric](28, 6) NULL,
	[jacketlabelprinternamex] [varchar](8000) NULL,
	[type_of_imaging] [numeric](28, 6) NULL,
	[typeofimagingx] [varchar](8000) NULL,
	[default_flash_card_format] [numeric](28, 6) NULL,
	[defaultflashcardformatx] [varchar](8000) NULL,
	[how_many_exam_labels_per_exam] [numeric](28, 6) NULL,
	[default_exam_label_format] [numeric](28, 6) NULL,
	[defaultexamlabelformatx] [varchar](8000) NULL,
	[report_printer_name] [numeric](28, 6) NULL,
	[reportprinternamex] [varchar](8000) NULL,
	[default_jacket_label_format] [numeric](28, 6) NULL,
	[defaultjacketlabelformatx] [varchar](8000) NULL,
	[default_report_header_format] [numeric](28, 6) NULL,
	[defaultreportheaderformatx] [varchar](8000) NULL,
	[default_report_footer_format] [numeric](28, 6) NULL,
	[defaultreportfooterformatx] [varchar](8000) NULL,
	[report_left_margin] [numeric](28, 6) NULL,
	[report_right_margin] [numeric](28, 6) NULL,
	[request_printer_name] [numeric](28, 6) NULL,
	[requestprinternamex] [varchar](8000) NULL,
	[allow_releasednot_verified] [varchar](8000) NULL,
	[print_dx_codes_in_report] [varchar](8000) NULL,
	[inactive] [datetime2](7) NULL,
	[urgent_request_alerts] [varchar](8000) NULL,
	[credit_method] [varchar](8000) NULL,
	[dss_id] [numeric](28, 6) NULL,
	[dssidx] [varchar](8000) NULL,
	[dosage_ticket_printer] [numeric](28, 6) NULL,
	[dosageticketprinterx] [varchar](8000) NULL,
	[cancelled_request_printer] [numeric](28, 6) NULL,
	[cancelledrequestprinterx] [varchar](8000) NULL,
	[radnuc_med_division] [numeric](28, 6) NULL,
	[radnucmeddivisionx] [varchar](8000) NULL,
	[voice_dictation_autoprint] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Imaging_Stop_Codes](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[valid_code] [numeric](28, 6) NULL,
	[validcodex] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Imaging_Type](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[type_of_imaging] [varchar](8000) NULL,
	[activity_log_cutoff] [numeric](28, 6) NULL,
	[report_cutoff] [numeric](28, 6) NULL,
	[clinical_history_cutoff] [numeric](28, 6) NULL,
	[tracking_time_cutoff] [numeric](28, 6) NULL,
	[order_data_cutoff] [numeric](28, 6) NULL,
	[abbreviation] [varchar](8000) NULL,
	[operating_conditions] [varchar](8000) NULL,
	[radiopharmaceuticals_used] [varchar](8000) NULL,
	[next_case_number] [numeric](28, 6) NULL,
	[case_number_turnover_date] [datetime2](7) NULL,
	[introductiontextwp] [text] NULL,
	[introductiontextwp_truncated] [varchar](8000) NULL,
	[pfssdeptcode] [varchar](8000) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Med_Common_Procedures](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[procedure_01] [numeric](28, 6) NULL,
	[procedure01x] [varchar](8000) NULL,
	[sequence_number] [numeric](28, 6) NULL,
	[inactive] [varchar](8000) NULL,
	[category_of_exam] [varchar](8000) NULL,
	[requested_date] [varchar](8000) NULL,
	[imaging_location] [numeric](28, 6) NULL,
	[imaginglocationx] [varchar](8000) NULL,
	[mode_of_transport] [varchar](8000) NULL,
	[isolation_procedures] [varchar](8000) NULL,
	[request_urgency] [varchar](8000) NULL,
	[name_of_orderable_item] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Med_Division](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[division] [numeric](28, 6) NULL,
	[divisionx] [varchar](8000) NULL,
	[track_exam_status_changes] [varchar](8000) NULL,
	[ask_exam_status_time] [varchar](8000) NULL,
	[allow_standard_reports] [varchar](8000) NULL,
	[allow_batching_of_reports] [varchar](8000) NULL,
	[allow_copying_of_reports] [varchar](8000) NULL,
	[allow_releasedunverified] [varchar](8000) NULL,
	[impression_required_on_reports] [varchar](8000) NULL,
	[ask_requested_date] [varchar](8000) NULL,
	[allow_verifying_by_residents] [varchar](8000) NULL,
	[track_request_status_changes] [varchar](8000) NULL,
	[print_flash_card_for_each_exam] [varchar](8000) NULL,
	[ask_imaging_location] [varchar](8000) NULL,
	[allow_rpts_on_cancelled_cases] [varchar](8000) NULL,
	[time_limit_for_future_exams] [numeric](28, 6) NULL,
	[warning_on_rpts_not_yet_verif] [varchar](8000) NULL,
	[auto_email_to_req_phys] [varchar](8000) NULL,
	[allow_esig_on_cots_hl7_rpts] [varchar](8000) NULL,
	[interpreting_staff_reqd] [varchar](8000) NULL,
	[auto_user_code_filing] [varchar](8000) NULL,
	[detailed_procedure_required] [varchar](8000) NULL,
	[print_jacket_lbls_weach_visit] [varchar](8000) NULL,
	[ask_cameraequiprm] [varchar](8000) NULL,
	[contrast_reaction_message] [varchar](8000) NULL,
	[clinical_history_message] [varchar](8000) NULL,
	[resource_device] [numeric](28, 6) NULL,
	[resourcedevicex] [varchar](8000) NULL,
	[rpharmdosewarningmessawp] [text] NULL,
	[rpharmdosewarningmessawp_truncated] [varchar](8000) NULL,
	[last_dfn_converted_751] [varchar](8000) NULL,
	[conversion_start_time_751] [datetime2](7) NULL,
	[conversion_stop_time_751] [datetime2](7) NULL,
	[last_dfn_converted_70] [varchar](8000) NULL,
	[conversion_start_time_70] [datetime2](7) NULL,
	[conversion_stop_time_70] [datetime2](7) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Med_Exam_Data](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[patient] [numeric](28, 6) NULL,
	[exam_datetime] [datetime2](7) NULL,
	[case_number] [numeric](28, 6) NULL,
	[PatientSID] [int] NULL,
	[PatientIEN] [varchar](50) NULL,
	[sta3n] [int] NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Med_Orders](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[name] [numeric](28, 6) NULL,
	[namex] [varchar](8000) NULL,
	[procedure2] [numeric](28, 6) NULL,
	[procedure2x] [varchar](8000) NULL,
	[type_of_imaging] [numeric](28, 6) NULL,
	[typeofimagingx] [varchar](8000) NULL,
	[category_of_exam] [varchar](8000) NULL,
	[request_status] [varchar](8000) NULL,
	[request_urgency] [varchar](8000) NULL,
	[order7] [numeric](28, 6) NULL,
	[order7x] [varchar](8000) NULL,
	[approving_radnuc_med_phys] [numeric](28, 6) NULL,
	[approvingradnucmedphysx] [varchar](8000) NULL,
	[contractsharing_source] [numeric](28, 6) NULL,
	[contractsharingsourcex] [varchar](8000) NULL,
	[research_source] [varchar](8000) NULL,
	[reason] [numeric](28, 6) NULL,
	[reasonx] [varchar](8000) NULL,
	[original_request_changed] [varchar](8000) NULL,
	[preop_scheduled_datetime] [datetime2](7) NULL,
	[pregnant] [varchar](8000) NULL,
	[requesting_physician] [numeric](28, 6) NULL,
	[requestingphysicianx] [varchar](8000) NULL,
	[user_entering_request] [numeric](28, 6) NULL,
	[userenteringrequestx] [varchar](8000) NULL,
	[request_entered_datetime] [datetime2](7) NULL,
	[past_visit_datetime] [datetime2](7) NULL,
	[last_activity_datetime] [datetime2](7) NULL,
	[mode_of_transport] [varchar](8000) NULL,
	[imaging_location] [numeric](28, 6) NULL,
	[imaginglocationx] [varchar](8000) NULL,
	[date_desired_not_guaranteed] [datetime2](7) NULL,
	[requesting_location] [numeric](28, 6) NULL,
	[requestinglocationx] [varchar](8000) NULL,
	[scheduled_date_time_optional] [datetime2](7) NULL,
	[isolation_procedures] [varchar](8000) NULL,
	[nature_of_new_order_activity] [varchar](8000) NULL,
	[cancel_description] [varchar](8000) NULL,
	[pfssaccountreferenceid] [numeric](28, 6) NULL,
	[pfssaccountreference] [varchar](8000) NULL,
	[primary_ordering_icd_diagnosis] [numeric](28, 6) NULL,
	[primaryorderingicddiagnosisx] [varchar](8000) NULL,
	[primary_dx_related_to_sc] [varchar](8000) NULL,
	[primary_dx_related_to_ao] [varchar](8000) NULL,
	[primary_dx_related_to_ir] [varchar](8000) NULL,
	[primary_dx_related_to_mst] [varchar](8000) NULL,
	[primary_dx_related_to_hnc] [varchar](8000) NULL,
	[primary_dx_related_to_cv] [varchar](8000) NULL,
	[holddescriptionwp] [text] NULL,
	[holddescriptionwp_truncated] [varchar](8000) NULL,
	[clinicalhistoryforexa0wp] [text] NULL,
	[clinicalhistoryforexa0wp_truncated] [varchar](8000) NULL,
	[reasonforstudy] [varchar](8000) NULL,
	[primarydxrelatedtoswac] [varchar](8000) NULL,
	[primarydxrelatedtoshad] [varchar](8000) NULL,
	[PatientSID] [int] NULL,
	[PatientIEN] [varchar](50) NULL,
	[sta3n] [int] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Med_Orders_X_Procedure_Modifiers](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[radnuc_med_orders] [numeric](28, 6) NULL,
	[childsub1] [numeric](28, 6) NULL,
	[procedure_modifiers] [numeric](28, 6) NULL,
	[proceduremodifiersx] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Med_Patients](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[name] [numeric](28, 6) NULL,
	[namex] [varchar](8000) NULL,
	[date_of_birth] [datetime2](7) NULL,
	[age] [numeric](28, 6) NULL,
	[usual_category] [varchar](8000) NULL,
	[user_who_entered_patient] [numeric](28, 6) NULL,
	[userwhoenteredpatientx] [varchar](8000) NULL,
	[eligibility_code] [varchar](8000) NULL,
	[narrative] [varchar](8000) NULL,
	[is_patient_a_veteran] [varchar](8000) NULL,
	[PatientSID] [int] NULL,
	[PatientIEN] [varchar](50) NULL,
	[sta3n] [int] NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Med_Procedures](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[name] [varchar](8000) NULL,
	[suppress_radiopharm_prompt] [varchar](8000) NULL,
	[required_flash_card_printer] [numeric](28, 6) NULL,
	[requiredflashcardprinterx] [varchar](8000) NULL,
	[required_flash_card_format] [numeric](28, 6) NULL,
	[requiredflashcardformatx] [varchar](8000) NULL,
	[prompt_for_meds] [varchar](8000) NULL,
	[type_of_procedure] [varchar](8000) NULL,
	[staff_review_required] [varchar](8000) NULL,
	[original_procedure] [varchar](8000) NULL,
	[cpt_code] [numeric](28, 6) NULL,
	[cptcodex] [varchar](8000) NULL,
	[cost_of_procedure] [numeric](28, 6) NULL,
	[radnm_phys_approval_required] [varchar](8000) NULL,
	[type_of_imaging] [numeric](28, 6) NULL,
	[typeofimagingx] [varchar](8000) NULL,
	[health_summary_with_request] [numeric](28, 6) NULL,
	[healthsummarywithrequestx] [varchar](8000) NULL,
	[default_cameraequiprm] [numeric](28, 6) NULL,
	[defaultcameraequiprmx] [varchar](8000) NULL,
	[display_ed_desc_when_ordered] [varchar](8000) NULL,
	[single_report] [varchar](8000) NULL,
	[prompt_for_radiopharm_rx] [varchar](8000) NULL,
	[contrast_media_used] [varchar](8000) NULL,
	[inactivation_date] [datetime2](7) NULL,
	[newproceduremessagewp] [text] NULL,
	[newproceduremessagewp_truncated] [varchar](8000) NULL,
	[educationaldescriptionwp] [text] NULL,
	[educationaldescriptionwp_truncated] [varchar](8000) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Med_Reason](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[number] [numeric](28, 6) NULL,
	[reason] [varchar](8000) NULL,
	[type_of_reason] [varchar](8000) NULL,
	[synonym] [varchar](8000) NULL,
	[nature_of_order_activity] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Med_Reports](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[daycase] [varchar](8000) NULL,
	[patient_name] [numeric](28, 6) NULL,
	[patientnamex] [varchar](8000) NULL,
	[exam_datetime] [datetime2](7) NULL,
	[case_number] [numeric](28, 6) NULL,
	[report_status] [varchar](8000) NULL,
	[date_report_entered] [datetime2](7) NULL,
	[verified_date] [datetime2](7) NULL,
	[reported_date] [datetime2](7) NULL,
	[verifying_physician] [numeric](28, 6) NULL,
	[verifyingphysicianx] [varchar](8000) NULL,
	[electronic_signature_code] [varchar](8000) NULL,
	[transcriptionist] [numeric](28, 6) NULL,
	[transcriptionistx] [varchar](8000) NULL,
	[date_report_printed] [datetime2](7) NULL,
	[preverification_datetime] [datetime2](7) NULL,
	[preverification_user] [numeric](28, 6) NULL,
	[preverificationuserx] [varchar](8000) NULL,
	[preverification_esig] [varchar](8000) NULL,
	[status_changed_to_verified_by] [numeric](28, 6) NULL,
	[statuschangedtoverifiedbyx] [varchar](8000) NULL,
	[problem_statement] [varchar](8000) NULL,
	[purged_date] [datetime2](7) NULL,
	[no_purge_indicator] [varchar](8000) NULL,
	[hospital_division] [varchar](8000) NULL,
	[imaging_location] [varchar](8000) NULL,
	[interpreting_imaging_location] [numeric](28, 6) NULL,
	[interpretingimaginglocationx] [varchar](8000) NULL,
	[procedure102] [varchar](8000) NULL,
	[exam_status] [varchar](8000) NULL,
	[category_of_exam] [varchar](8000) NULL,
	[ward] [varchar](8000) NULL,
	[service] [varchar](8000) NULL,
	[principal_clinic] [varchar](8000) NULL,
	[contractsharing_source] [varchar](8000) NULL,
	[research_source] [varchar](8000) NULL,
	[primary_interpreting_resident] [varchar](8000) NULL,
	[primary_diagnostic_code] [varchar](8000) NULL,
	[requesting_physician] [varchar](8000) NULL,
	[primary_interpreting_staff] [varchar](8000) NULL,
	[complication] [varchar](8000) NULL,
	[primary_cameraequiprm] [varchar](8000) NULL,
	[bedsection] [varchar](8000) NULL,
	[reporttextwp] [text] NULL,
	[reporttextwp_truncated] [varchar](8000) NULL,
	[impressiontextwp] [text] NULL,
	[impressiontextwp_truncated] [varchar](8000) NULL,
	[additionalclinicalhistwp] [text] NULL,
	[additionalclinicalhistwp_truncated] [varchar](8000) NULL,
	[node_p] [varchar](8000) NULL,
	[tlrdlgyphyscnname] [varchar](8000) NULL,
	[teleradiologyphysiciannpi] [varchar](8000) NULL,
	[reportverifiedbycotsappid] [numeric](28, 6) NULL,
	[reportverifiedbycotsapp] [varchar](8000) NULL,
	[dateintlotsdrptentry] [datetime2](7) NULL,
	[PatientSID] [int] NULL,
	[PatientIEN] [varchar](50) NULL,
	[sta3n] [int] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO



CREATE TABLE [MSSR].[MSSR_Radiology_Med_Rx_Other_Case](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[radnuc_med_reports] [numeric](28, 6) NULL,
	[childsub1] [numeric](28, 6) NULL,
	[other_case] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Med_X_Decendents](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[radnuc_med_procedures] [numeric](28, 6) NULL,
	[childsub1] [numeric](28, 6) NULL,
	[descendents] [numeric](28, 6) NULL,
	[descendentsx] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Modality_defined_Terms](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[modality_abbreviation] [varchar](8000) NULL,
	[modality_name] [varchar](8000) NULL,
	[status] [varchar](8000) NULL,
	[replaced_by] [numeric](28, 6) NULL,
	[replacedbyx] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Rdlgycptbyprcdrtype](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[code] [varchar](8000) NULL,
	[waittimesproceduretype] [varchar](8000) NULL,
	[proceduresubcategory] [varchar](8000) NULL,
	[rvuproceduretype] [varchar](8000) NULL,
	[descriptor_] [varchar](8000) NULL,
	[cmsworkrvu] [numeric](28, 6) NULL,
	[vagapwrvu] [numeric](28, 6) NULL,
	[biradsprocedure] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Registered_Exams](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[radnuc_med_patient] [numeric](28, 6) NULL,
	[childsub1] [numeric](28, 6) NULL,
	[exam_date] [datetime2](7) NULL,
	[type_of_imaging] [numeric](28, 6) NULL,
	[typeofimagingx] [varchar](8000) NULL,
	[hospital_division] [numeric](28, 6) NULL,
	[hospitaldivisionx] [varchar](8000) NULL,
	[imaging_location] [numeric](28, 6) NULL,
	[imaginglocationx] [varchar](8000) NULL,
	[exam_set] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Route_of_Administration](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[name] [varchar](8000) NULL,
	[prompt_for_free_text_site] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Secondary_Diagnostic_Codes](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[sub_examinations] [varchar](8000) NULL,
	[childsub3] [numeric](28, 6) NULL,
	[secondary_diagnostic_code] [numeric](28, 6) NULL,
	[secondarydiagnosticcodex] [varchar](8000) NULL,
	[secondary_dx_print_date] [datetime2](7) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Site_of_Administration](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[name] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Standard_Reports](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[report_number] [numeric](28, 6) NULL,
	[standard_report] [varchar](8000) NULL,
	[reporttext0wp] [text] NULL,
	[reporttext0wp_truncated] [varchar](8000) NULL,
	[impressionwp] [text] NULL,
	[impressionwp_truncated] [varchar](8000) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Subexam_Contrast_Media](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[sub_examinations] [varchar](8000) NULL,
	[childsub3] [numeric](28, 6) NULL,
	[contrast_media] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Subexam_CptModifiers](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[sub_examinations] [varchar](8000) NULL,
	[childsub3] [numeric](28, 6) NULL,
	[cpt_modifiers] [numeric](28, 6) NULL,
	[cptmodifiersx] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_Ward_Locations](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[name] [varchar](8000) NULL,
	[division] [numeric](28, 6) NULL,
	[divisionx] [varchar](8000) NULL,
	[specialty] [numeric](28, 6) NULL,
	[specialtyx] [varchar](8000) NULL,
	[bedsection] [varchar](8000) NULL,
	[service] [varchar](8000) NULL,
	[raimds_ward] [varchar](8000) NULL,
	[print_ward_on_wristband] [varchar](8000) NULL,
	[fy_target] [numeric](28, 6) NULL,
	[seriously_ill] [varchar](8000) NULL,
	[terminal] [numeric](28, 6) NULL,
	[primary_location] [varchar](8000) NULL,
	[intermediate_medicine__ltc] [varchar](8000) NULL,
	[currently_outofservice] [varchar](8000) NULL,
	[beds_outofservice] [numeric](28, 6) NULL,
	[authorized_beds] [numeric](28, 6) NULL,
	[operating_beds] [numeric](28, 6) NULL,
	[hospital_location_file_pointer] [numeric](28, 6) NULL,
	[hospitallocationfilepointerx] [varchar](8000) NULL,
	[gl_order] [numeric](28, 6) NULL,
	[gl_header] [varchar](8000) NULL,
	[acuity_class] [varchar](8000) NULL,
	[nserv] [varchar](8000) NULL,
	[node_header] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_X_Clinical_History](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[radnuc_med_orders] [numeric](28, 6) NULL,
	[childsub1] [numeric](28, 6) NULL,
	[clinical_history_for_exam] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_X_Exam_Status_Times](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[sub_examinations] [varchar](8000) NULL,
	[childsub3] [numeric](28, 6) NULL,
	[status_change_datetime] [datetime2](7) NULL,
	[new_status] [numeric](28, 6) NULL,
	[newstatusx] [varchar](8000) NULL,
	[computer_user] [numeric](28, 6) NULL,
	[computeruserx] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_X_Examinations](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[parentrowid_70] [numeric](28, 6) NULL,
	[sub_registered_exams] [varchar](8000) NULL,
	[childsub2] [numeric](28, 6) NULL,
	[exam_date] [datetime2](7) NULL,
	[case_number] [numeric](28, 6) NULL,
	[procedure2] [numeric](28, 6) NULL,
	[procedure2x] [varchar](8000) NULL,
	[exam_status] [numeric](28, 6) NULL,
	[examstatusx] [varchar](8000) NULL,
	[reason_for_cancellation] [numeric](28, 6) NULL,
	[reasonforcancellationx] [varchar](8000) NULL,
	[category_of_exam] [varchar](8000) NULL,
	[ward] [numeric](28, 6) NULL,
	[wardx] [varchar](8000) NULL,
	[service] [numeric](28, 6) NULL,
	[servicex] [varchar](8000) NULL,
	[principal_clinic] [numeric](28, 6) NULL,
	[principalclinicx] [varchar](8000) NULL,
	[contractsharing_source] [numeric](28, 6) NULL,
	[contractsharingsourcex] [varchar](8000) NULL,
	[research_source] [varchar](8000) NULL,
	[contrast_media_used] [varchar](8000) NULL,
	[imaging_order] [numeric](28, 6) NULL,
	[imagingorderx] [varchar](8000) NULL,
	[primary_interpreting_resident] [numeric](28, 6) NULL,
	[primaryinterpretingresidentx] [varchar](8000) NULL,
	[primary_diagnostic_code] [numeric](28, 6) NULL,
	[primarydiagnosticcodex] [varchar](8000) NULL,
	[requesting_physician] [numeric](28, 6) NULL,
	[requestingphysicianx] [varchar](8000) NULL,
	[primary_interpreting_staff] [numeric](28, 6) NULL,
	[primaryinterpretingstaffx] [varchar](8000) NULL,
	[complication] [numeric](28, 6) NULL,
	[complicationx] [varchar](8000) NULL,
	[complication_text] [varchar](8000) NULL,
	[report_text] [numeric](28, 6) NULL,
	[reporttextx] [varchar](8000) NULL,
	[primary_cameraequiprm] [numeric](28, 6) NULL,
	[primarycameraequiprmx] [varchar](8000) NULL,
	[bedsection] [numeric](28, 6) NULL,
	[bedsectionx] [varchar](8000) NULL,
	[diagnostic_print_date] [datetime2](7) NULL,
	[requested_date] [datetime2](7) NULL,
	[requesting_location] [numeric](28, 6) NULL,
	[requestinglocationx] [varchar](8000) NULL,
	[clinic_stop_recorded] [varchar](8000) NULL,
	[member_of_set] [varchar](8000) NULL,
	[credit_method] [varchar](8000) NULL,
	[visit] [numeric](28, 6) NULL,
	[visitx] [varchar](8000) NULL,
	[dosage_ticket_printed] [varchar](8000) NULL,
	[hl7_examined_msg_sent] [varchar](8000) NULL,
	[purged_date] [datetime2](7) NULL,
	[prevent_purge] [varchar](8000) NULL,
	[clinicalhistoryforexamwp] [text] NULL,
	[clinicalhistoryforexamwp_truncated] [varchar](8000) NULL,
	[nuclear_med_data] [numeric](28, 6) NULL,
	[nuclearmeddatax] [varchar](8000) NULL,
	[pregnancyscreen] [varchar](8000) NULL,
	[pregnancyscreencomment] [varchar](8000) NULL,
	[PatientSID] [int] NULL,
	[PatientIEN] [varchar](50) NULL,
	[sta3n] [int] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_X_Imaging_Locations](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[radnuc_med_division] [numeric](28, 6) NULL,
	[childsub1] [numeric](28, 6) NULL,
	[imaging_location] [numeric](28, 6) NULL,
	[imaginglocationx] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_X_Outside_Films](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[radnuc_med_patient] [numeric](28, 6) NULL,
	[childsub1] [numeric](28, 6) NULL,
	[outside_films_register_date] [datetime2](7) NULL,
	[needed_back_date] [datetime2](7) NULL,
	[returned_date] [datetime2](7) NULL,
	[source_of_films] [varchar](8000) NULL,
	[ask_for_ok_before_returning] [varchar](8000) NULL,
	[has_return_been_oked] [varchar](8000) NULL,
	[remarks] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_X_Procedure_Modifiers](
	[station__no] [varchar](30) NULL,
	[row_id] [numeric](28, 6) NULL,
	[name] [varchar](8000) NULL,
	[amis_credit_indicator] [varchar](8000) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_Radiology_X_Radiopharmaceutical](
	[station__no] [varchar](30) NULL,
	[row_id] [varchar](8000) NULL,
	[nuc_med_exam_data] [numeric](28, 6) NULL,
	[childsub1] [numeric](28, 6) NULL,
	[radiopharmaceutical] [numeric](28, 6) NULL,
	[radiopharmaceuticalx] [varchar](8000) NULL,
	[prescribed_dose_by_md_override] [numeric](28, 6) NULL,
	[prescribing_physician] [numeric](28, 6) NULL,
	[prescribingphysicianx] [varchar](8000) NULL,
	[activity_drawn_in_mci] [numeric](28, 6) NULL,
	[datetime_drawn] [datetime2](7) NULL,
	[person_who_measured_dose] [numeric](28, 6) NULL,
	[personwhomeasureddosex] [varchar](8000) NULL,
	[dose_administered] [numeric](28, 6) NULL,
	[datetime_dose_administered] [datetime2](7) NULL,
	[person_who_administered_dose] [numeric](28, 6) NULL,
	[personwhoadministereddosex] [varchar](8000) NULL,
	[witness_to_dose_administration] [numeric](28, 6) NULL,
	[witnesstodoseadministrationx] [varchar](8000) NULL,
	[route_of_administration] [numeric](28, 6) NULL,
	[routeofadministrationx] [varchar](8000) NULL,
	[site_of_administration] [numeric](28, 6) NULL,
	[siteofadministrationx] [varchar](8000) NULL,
	[site_of_admin_text] [varchar](8000) NULL,
	[lot_no] [numeric](28, 6) NULL,
	[volume_in_ml_or_caplets] [varchar](8000) NULL,
	[form] [varchar](8000) NULL
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

